// Operating System : Windows XP or later, 
// Scilab           : 5.3.3 

//True and Estimated value of mean and variance of function of one random 
//variable having form of Y = aX +b.
clc;
clear all;
rand('seed',getdate('s'))
m = 0;//mean of random variable x
vari = 1;//variance of random variable x
m_est = 0;
var_est = 0;
for i = 1:1000
    y(i,1)= 1 +2*rand(1,1,"normal");// Y = 2X + 1 where x is gaussian data
    m_est = m_est + ((1/1000)*y(i));//estimation by averaging
    var_est = var_est +((1/1000)*(y(i)-m_est)^2);
end
printf('Estimated mean of Y(=2X + 1) is: Est_mean=%f',m_est)
printf('\n Estimated variance of Y) is: Est_variance =%f',var_est)
//Calculation of true mean of Y
y_mean=integrate('(2*x+1)*(1/sqrt(2*%pi*vari)*exp(-(x-m)^2/(2*vari)))','x',-100,100);
printf('\n True mean of Y(=2X + 1) is: True_mean=%f',y_mean)
//Calculation of true variance of Y
//for a function like Y = aX + b the variance of Y is a^2*Variance of X.
gs_mean=integrate('x*(1/sqrt(2*%pi*vari)*exp(-(x-m)^2/(2*vari)))','x',-50,100);
gs_fsq=integrate('((x^2)*(1/sqrt(2*%pi*vari)*exp(-(x-m)^2/(2*vari))))','x',-50,100);
gs_var = gs_fsq - (gs_mean).^2;
var_y = 2^2*gs_var;//here a = 2
printf('\n True variance of Y(=2X + 1) is: True_variance=%f',var_y)

//Expectation of Y is E(Y)=E(2X+1)=2E(X)+1. That's why answer is 1.
//True variance of Y in this format is equal to a^2*variance of X.
//Assignment:
//1. Assume X is uniform random variable between a to b. find mean and variance.
